package idemia.ipv.pojo.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.time.LocalDateTime;


@Data
public class NotificationPayload {

    @JsonProperty("businessId")
    private String businessId;
    @JsonProperty("event")
    private EventType event;
    @JsonProperty("identityId")
    private String identityId;
    @JsonProperty("completedAt")
    private LocalDateTime completedAt;
    @JsonProperty("evidence")
    private NotificationEvidence evidence;

    @Data
    public static class NotificationEvidence {
        @JsonProperty("evidenceId")
        private String evidenceId;
        @JsonProperty("evidenceType")
        private String evidenceType;
        @JsonProperty("evidenceOperation")
        private String evidenceOperation;
    }
}
